* Program to dump street data out of the national
* file using the StreetData interface of the AddressObject COM Object
*********************************************************************************
*If you should have any comments, suggestions or improvements to these samples, 
*we welcome you to contact us at SampleCode@melissadata.com also please visit our 
*developers bulletin board at forum.melissadata.com.
*********************************************************************************

clear
close all

* Use and remove any previous records 
use stdata alias street
delete all
pack

* Use the StreetData interface of the AddressObject component
AddressObj = CreateObject('AddressObject.StreetData')

********************** LICENSE STRINGS *************************
*      To unlock the full functionality of Address Object,     *
*  please call a sales representative at 1-800-MELISSA ext. 3  *
*          (1-800-635-4772 x3) for a license string.           *
*        Without a valid license string, StreetData will       *
*                 only verify Nevada addresses.                *
*                                                              *
* NOTE: Replace DEMO in the parameter with your license string *
****************************************************************
if (AddressObj.SetLicenseString("DEMO") = 0)
	@1,1 say "Component is in DEMO Mode"
endif

***************************************************************
* Set path for data files below.  The default location is
* entered.  If different, please enter the datapath between
* the quotation marks.
* The Data Files Directory must contain the following files: 
* mdAddr.dat, mdAddr.lic, mdAddr.nat, mdAddr.sfx and mdAddr.str.
***************************************************************
* Initialize the data files
if (AddressObj.Initialize("C:\Program Files\Melissa DATA\DQT\Data","C:\Program Files\Melissa DATA\DQT\Data")!=0)
	wait ZipObject.GetInitializeErrorString		* Initialization failed
	return
endif

@2,1 say "Initialized"

* Dump Nevada Street Data for some Nevada ZIP Codes
for zipx=89101 to 89112

	@3,1 say zipx

	* Get information for this ZIP Code
	result = AddressObj.FindStreet("*", zipx, 1)

	* Replace fields with data from ZIP Code
	do while result=1
		appe blank
		repl zip with AddressObj.Zip
		repl record_typ with AddressObj.AddressType
		repl cart with AddressObj.CarrierRoute
		repl predir with AddressObj.PreDirection
		repl name with AddressObj.StreetName
		repl suffix with AddressObj.Suffix
		repl postdir with AddressObj.PostDirection
		repl pri_low with AddressObj.PrimaryRangeLow
		repl pri_high with AddressObj.PrimaryRangeHigh
		repl pri_oddeve with AddressObj.PrimaryRangeOddEven
		repl company with AddressObj.Company
		repl sec_name with AddressObj.SuiteName
		repl sec_low with AddressObj.SuiteRangeLow
		repl sec_high with AddressObj.SuiteRangeHigh
		repl sec_oddeve with AddressObj.SuiteRangeOddEven
		repl zip4_low with AddressObj.Plus4Low
		repl zip4_high with AddressObj.Plus4High
		repl base_alt with AddressObj.BaseAlternateIndicator
		repl lacs with AddressObj.LacsIndicator
		repl county_no with right(AddressObj.CountyFips, 3)
		repl cd with AddressObj.CongressionalDistrict
		repl lst_ctykey with AddressObj.LastLineNumber
		repl urban with AddressObj.UrbanizationCode

		* Get any additional data from this ZIP Code
		result = AddressObj.FindStreetNext()
	enddo
endfor

* Release the component
release AddressObj
